// SPDX-License-Identifier: GPL-2.0
// Trace events for the ChromeOS Embedded Controller
//
// Copyright 2025 Google LLC.

#define TRACE_SYMBOL(a) {a, #a}

// Generate the list using the following script:
// sed -n 's/^.*\(MOTIONSENSE_CMD.*\) = .*,$/\tTRACE_SYMBOL(\1), \\/p' include/linux/platform_data/cros_ec_commands.h
#define MOTIONSENSE_CMDS \
	TRACE_SYMBOL(MOTIONSENSE_CMD_DUMP), \
	TRACE_SYMBOL(MOTIONSENSE_CMD_INFO), \
	TRACE_SYMBOL(MOTIONSENSE_CMD_EC_RATE), \
	TRACE_SYMBOL(MOTIONSENSE_CMD_SENSOR_ODR), \
	TRACE_SYMBOL(MOTIONSENSE_CMD_SENSOR_RANGE), \
	TRACE_SYMBOL(MOTIONSENSE_CMD_KB_WAKE_ANGLE), \
	TRACE_SYMBOL(MOTIONSENSE_CMD_DATA), \
	TRACE_SYMBOL(MOTIONSENSE_CMD_FIFO_INFO), \
	TRACE_SYMBOL(MOTIONSENSE_CMD_FIFO_FLUSH), \
	TRACE_SYMBOL(MOTIONSENSE_CMD_FIFO_READ), \
	TRACE_SYMBOL(MOTIONSENSE_CMD_PERFORM_CALIB), \
	TRACE_SYMBOL(MOTIONSENSE_CMD_SENSOR_OFFSET), \
	TRACE_SYMBOL(MOTIONSENSE_CMD_LIST_ACTIVITIES), \
	TRACE_SYMBOL(MOTIONSENSE_CMD_SET_ACTIVITY), \
	TRACE_SYMBOL(MOTIONSENSE_CMD_LID_ANGLE), \
	TRACE_SYMBOL(MOTIONSENSE_CMD_FIFO_INT_ENABLE), \
	TRACE_SYMBOL(MOTIONSENSE_CMD_SPOOF), \
	TRACE_SYMBOL(MOTIONSENSE_CMD_TABLET_MODE_LID_ANGLE), \
	TRACE_SYMBOL(MOTIONSENSE_CMD_SENSOR_SCALE)

#define CREATE_TRACE_POINTS
#include "cros_ec_sensors_trace.h"
