/* SPDX-License-Identifier: GPL-2.0 */
/*
 * Copyright (C) Marvell International Ltd. and its affiliates
 */

#ifndef _DDR3_TRAINING_IP_DB_H_
#define _DDR3_TRAINING_IP_DB_H_

enum hws_pattern {
#if   defined(CONFIG_DDR4) /* DDR4 16/32-bit */
	PATTERN_PBS1,/*0*/
	PATTERN_PBS2,
	PATTERN_PBS3,
	PATTERN_TEST,
	PATTERN_RL,
	PATTERN_RL2,
	PATTERN_STATIC_PBS,
	PATTERN_KILLER_DQ0,
	PATTERN_KILLER_DQ1,
	PATTERN_KILLER_DQ2,
	PATTERN_KILLER_DQ3,/*10*/
	PATTERN_KILLER_DQ4,
	PATTERN_KILLER_DQ5,
	PATTERN_KILLER_DQ6,
	PATTERN_KILLER_DQ7,
	PATTERN_KILLER_DQ0_INV,
	PATTERN_KILLER_DQ1_INV,
	PATTERN_KILLER_DQ2_INV,
	PATTERN_KILLER_DQ3_INV,
	PATTERN_KILLER_DQ4_INV,
	PATTERN_KILLER_DQ5_INV,/*20*/
	PATTERN_KILLER_DQ6_INV,
	PATTERN_KILLER_DQ7_INV,
	PATTERN_VREF,
	PATTERN_VREF_INV,
	PATTERN_FULL_SSO0,
	PATTERN_FULL_SSO1,
	PATTERN_FULL_SSO2,
	PATTERN_FULL_SSO3,
	PATTERN_ZERO,
	PATTERN_ONE,
	PATTERN_LAST,
	PATTERN_SSO_FULL_XTALK_DQ0,
	PATTERN_SSO_FULL_XTALK_DQ1,/*30*/
	PATTERN_SSO_FULL_XTALK_DQ2,
	PATTERN_SSO_FULL_XTALK_DQ3,
	PATTERN_SSO_FULL_XTALK_DQ4,
	PATTERN_SSO_FULL_XTALK_DQ5,
	PATTERN_SSO_FULL_XTALK_DQ6,
	PATTERN_SSO_FULL_XTALK_DQ7,
	PATTERN_SSO_XTALK_FREE_DQ0,
	PATTERN_SSO_XTALK_FREE_DQ1,
	PATTERN_SSO_XTALK_FREE_DQ2,
	PATTERN_SSO_XTALK_FREE_DQ3,/*40*/
	PATTERN_SSO_XTALK_FREE_DQ4,
	PATTERN_SSO_XTALK_FREE_DQ5,
	PATTERN_SSO_XTALK_FREE_DQ6,
	PATTERN_SSO_XTALK_FREE_DQ7,
	PATTERN_ISI_XTALK_FREE,
	PATTERN_RESONANCE_1T,
	PATTERN_RESONANCE_2T,
	PATTERN_RESONANCE_3T,
	PATTERN_RESONANCE_4T,
	PATTERN_RESONANCE_5T,/*50*/
	PATTERN_RESONANCE_6T,
	PATTERN_RESONANCE_7T,
	PATTERN_RESONANCE_8T,
	PATTERN_RESONANCE_9T
#else /* DDR3 16/32-bit */
	PATTERN_PBS1,
	PATTERN_PBS2,
	PATTERN_PBS3,
	PATTERN_TEST,
	PATTERN_RL,
	PATTERN_RL2,
	PATTERN_STATIC_PBS,
	PATTERN_KILLER_DQ0,
	PATTERN_KILLER_DQ1,
	PATTERN_KILLER_DQ2,
	PATTERN_KILLER_DQ3,
	PATTERN_KILLER_DQ4,
	PATTERN_KILLER_DQ5,
	PATTERN_KILLER_DQ6,
	PATTERN_KILLER_DQ7,
	PATTERN_VREF,
	PATTERN_FULL_SSO0,
	PATTERN_FULL_SSO1,
	PATTERN_FULL_SSO2,
	PATTERN_FULL_SSO3,
	PATTERN_LAST,
	PATTERN_SSO_FULL_XTALK_DQ0,
	PATTERN_SSO_FULL_XTALK_DQ1,
	PATTERN_SSO_FULL_XTALK_DQ2,
	PATTERN_SSO_FULL_XTALK_DQ3,
	PATTERN_SSO_FULL_XTALK_DQ4,
	PATTERN_SSO_FULL_XTALK_DQ5,
	PATTERN_SSO_FULL_XTALK_DQ6,
	PATTERN_SSO_FULL_XTALK_DQ7,
	PATTERN_SSO_XTALK_FREE_DQ0,
	PATTERN_SSO_XTALK_FREE_DQ1,
	PATTERN_SSO_XTALK_FREE_DQ2,
	PATTERN_SSO_XTALK_FREE_DQ3,
	PATTERN_SSO_XTALK_FREE_DQ4,
	PATTERN_SSO_XTALK_FREE_DQ5,
	PATTERN_SSO_XTALK_FREE_DQ6,
	PATTERN_SSO_XTALK_FREE_DQ7,
	PATTERN_ISI_XTALK_FREE
#endif /* CONFIG_64BIT */
};

enum mv_wl_supp_mode {
	WRITE_LEVELING_SUPP_REG_MODE,
	WRITE_LEVELING_SUPP_ECC_MODE_DATA_PUPS,
	WRITE_LEVELING_SUPP_ECC_MODE_ECC_PUP4,
	WRITE_LEVELING_SUPP_ECC_MODE_ECC_PUP3,
	WRITE_LEVELING_SUPP_ECC_MODE_ECC_PUP8
};

enum mv_ddr_dev_attribute {
	MV_ATTR_TIP_REV,
	MV_ATTR_PHY_EDGE,
	MV_ATTR_OCTET_PER_INTERFACE,
	MV_ATTR_PLL_BEFORE_INIT,
	MV_ATTR_TUNE_MASK,
	MV_ATTR_INIT_FREQ,
	MV_ATTR_MID_FREQ,
	MV_ATTR_DFS_LOW_FREQ,
	MV_ATTR_DFS_LOW_PHY,
	MV_ATTR_DELAY_ENABLE,
	MV_ATTR_CK_DELAY,
	MV_ATTR_CA_DELAY,
	MV_ATTR_INTERLEAVE_WA,
	MV_ATTR_LAST
};

enum mv_ddr_tip_revison {
	MV_TIP_REV_NA,
	MV_TIP_REV_1, /* NP5 */
	MV_TIP_REV_2, /* BC2 */
	MV_TIP_REV_3, /* AC3 */
	MV_TIP_REV_4, /* A-380/A-390 */
	MV_TIP_REV_LAST
};

enum mv_ddr_phy_edge {
	MV_DDR_PHY_EDGE_POSITIVE,
	MV_DDR_PHY_EDGE_NEGATIVE
};

/* Device attribute functions */
void ddr3_tip_dev_attr_init(u32 dev_num);
u32 ddr3_tip_dev_attr_get(u32 dev_num, enum mv_ddr_dev_attribute attr_id);
void ddr3_tip_dev_attr_set(u32 dev_num, enum mv_ddr_dev_attribute attr_id, u32 value);

#endif /* _DDR3_TRAINING_IP_DB_H_ */
