; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mcpu=pwr10 -ppc-asm-full-reg-names --enable-unsafe-fp-math \
; RUN:   -verify-machineinstrs --enable-no-signed-zeros-fp-math \
; RUN:   --enable-no-nans-fp-math \
; RUN:   -mtriple=powerpc64le-unknown-unknown < %s | FileCheck %s
; RUN: llc -mcpu=pwr10 -ppc-asm-full-reg-names -verify-machineinstrs \
; RUN:   -mtriple=powerpc64le-unknown-unknown < %s | FileCheck %s
define dso_local fp128 @testqmax(fp128 %a, fp128 %b) local_unnamed_addr {
; CHECK-LABEL: testqmax:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xsmaxcqp v2, v2, v3
; CHECK-NEXT:    blr
entry:
  %cmp = fcmp ogt fp128 %a, %b
  %cond = select i1 %cmp, fp128 %a, fp128 %b
  ret fp128 %cond
}

define dso_local fp128 @testqmin(fp128 %a, fp128 %b) local_unnamed_addr {
; CHECK-LABEL: testqmin:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xsmincqp v2, v2, v3
; CHECK-NEXT:    blr
entry:
  %cmp = fcmp olt fp128 %a, %b
  %cond = select i1 %cmp, fp128 %a, fp128 %b
  ret fp128 %cond
}

define dso_local fp128 @testqmax_fast(fp128 %a, fp128 %b) local_unnamed_addr {
; CHECK-LABEL: testqmax_fast:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xsmaxcqp v2, v2, v3
; CHECK-NEXT:    blr
entry:
  %cmp = fcmp nnan ninf ogt fp128 %a, %b
  %cond = select i1 %cmp, fp128 %a, fp128 %b
  ret fp128 %cond
}

define dso_local fp128 @testqmin_fast(fp128 %a, fp128 %b) local_unnamed_addr {
; CHECK-LABEL: testqmin_fast:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xsmincqp v2, v2, v3
; CHECK-NEXT:    blr
entry:
  %cmp = fcmp nnan ninf olt fp128 %a, %b
  %cond = select i1 %cmp, fp128 %a, fp128 %b
  ret fp128 %cond
}

declare fp128 @llvm.maxnum.f128(fp128, fp128)
define dso_local fp128 @testq_intrinsic_maxnum(fp128 %a, fp128 %b) local_unnamed_addr {
; CHECK-LABEL: testq_intrinsic_maxnum:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xsmaxcqp v2, v2, v3
; CHECK-NEXT:    blr
entry:
  %0 = tail call fast fp128 @llvm.maxnum.f128(fp128 %a, fp128 %b)
  ret fp128 %0
}

declare fp128 @llvm.minnum.f128(fp128, fp128)
define dso_local fp128 @testq_intrinsic_minnum(fp128 %a, fp128 %b) local_unnamed_addr {
; CHECK-LABEL: testq_intrinsic_minnum:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xsmincqp v2, v2, v3
; CHECK-NEXT:    blr
entry:
  %0 = tail call fast fp128 @llvm.minnum.f128(fp128 %a, fp128 %b)
  ret fp128 %0
}

define fp128 @olt_sel(fp128 %a, fp128 %b) {
; CHECK-LABEL: olt_sel:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    plxv vs36, .LCPI6_0@PCREL(0), 1
; CHECK-NEXT:    xscmpuqp cr0, v2, v4
; CHECK-NEXT:    blt cr0, .LBB6_2
; CHECK-NEXT:  # %bb.1: # %entry
; CHECK-NEXT:    vmr v3, v4
; CHECK-NEXT:  .LBB6_2: # %entry
; CHECK-NEXT:    vmr v2, v3
; CHECK-NEXT:    blr
entry:
  %0 = fcmp fast olt fp128 %a, 0xL00000000000000000000000000000000
  %1 = select i1 %0, fp128 %b, fp128 0xL00000000000000000000000000000000
  ret fp128 %1
}
