; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc  -O0 -mtriple=mipsel-linux-gnu -global-isel  -verify-machineinstrs %s -o -| FileCheck %s -check-prefixes=MIPS32

define void @long_chain_ambiguous_i64_in_fpr(i1 %cnd0, i1 %cnd1, i1 %cnd2, ptr %a, ptr %b, ptr %c, ptr %result) {
; MIPS32-LABEL: long_chain_ambiguous_i64_in_fpr:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    addiu $sp, $sp, -72
; MIPS32-NEXT:    .cfi_def_cfa_offset 72
; MIPS32-NEXT:    sw $4, 44($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    sw $5, 48($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    sw $6, 52($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    sw $7, 56($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    addiu $1, $sp, 88
; MIPS32-NEXT:    lw $1, 0($1)
; MIPS32-NEXT:    sw $1, 60($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    addiu $1, $sp, 92
; MIPS32-NEXT:    lw $1, 0($1)
; MIPS32-NEXT:    sw $1, 64($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    addiu $1, $sp, 96
; MIPS32-NEXT:    lw $1, 0($1)
; MIPS32-NEXT:    sw $1, 68($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    andi $1, $4, 1
; MIPS32-NEXT:    bnez $1, $BB0_12
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  # %bb.1: # %entry
; MIPS32-NEXT:    j $BB0_2
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  $BB0_2: # %pre.PHI.1
; MIPS32-NEXT:    lw $1, 48($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    andi $1, $1, 1
; MIPS32-NEXT:    bnez $1, $BB0_7
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  # %bb.3: # %pre.PHI.1
; MIPS32-NEXT:    j $BB0_4
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  $BB0_4: # %pre.PHI.1.0
; MIPS32-NEXT:    lw $1, 52($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    andi $1, $1, 1
; MIPS32-NEXT:    bnez $1, $BB0_8
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  # %bb.5: # %pre.PHI.1.0
; MIPS32-NEXT:    j $BB0_6
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  $BB0_6: # %b.PHI.1.0
; MIPS32-NEXT:    lw $1, 56($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    ldc1 $f0, 0($1)
; MIPS32-NEXT:    sdc1 $f0, 32($sp) # 8-byte Folded Spill
; MIPS32-NEXT:    j $BB0_9
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  $BB0_7: # %b.PHI.1.1
; MIPS32-NEXT:    lw $1, 60($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    ldc1 $f0, 0($1)
; MIPS32-NEXT:    sdc1 $f0, 32($sp) # 8-byte Folded Spill
; MIPS32-NEXT:    j $BB0_9
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  $BB0_8: # %b.PHI.1.2
; MIPS32-NEXT:    lw $1, 64($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    ldc1 $f0, 0($1)
; MIPS32-NEXT:    sdc1 $f0, 32($sp) # 8-byte Folded Spill
; MIPS32-NEXT:    j $BB0_9
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  $BB0_9: # %b.PHI.1
; MIPS32-NEXT:    lw $1, 52($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    ldc1 $f0, 32($sp) # 8-byte Folded Reload
; MIPS32-NEXT:    sdc1 $f0, 16($sp) # 8-byte Folded Spill
; MIPS32-NEXT:    andi $1, $1, 1
; MIPS32-NEXT:    sdc1 $f0, 24($sp) # 8-byte Folded Spill
; MIPS32-NEXT:    bnez $1, $BB0_11
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  # %bb.10: # %b.PHI.1
; MIPS32-NEXT:    j $BB0_19
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  $BB0_11: # %b.PHI.1.end
; MIPS32-NEXT:    ldc1 $f0, 16($sp) # 8-byte Folded Reload
; MIPS32-NEXT:    lw $1, 68($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    sdc1 $f0, 0($1)
; MIPS32-NEXT:    addiu $sp, $sp, 72
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  $BB0_12: # %pre.PHI.2
; MIPS32-NEXT:    lw $1, 44($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    andi $1, $1, 1
; MIPS32-NEXT:    bnez $1, $BB0_14
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  # %bb.13: # %pre.PHI.2
; MIPS32-NEXT:    j $BB0_15
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  $BB0_14: # %b.PHI.2.0
; MIPS32-NEXT:    lw $1, 56($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    ldc1 $f0, 0($1)
; MIPS32-NEXT:    sdc1 $f0, 8($sp) # 8-byte Folded Spill
; MIPS32-NEXT:    j $BB0_16
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  $BB0_15: # %b.PHI.2.1
; MIPS32-NEXT:    lw $1, 60($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    ldc1 $f0, 0($1)
; MIPS32-NEXT:    sdc1 $f0, 8($sp) # 8-byte Folded Spill
; MIPS32-NEXT:    j $BB0_16
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  $BB0_16: # %b.PHI.2
; MIPS32-NEXT:    lw $1, 48($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    ldc1 $f0, 8($sp) # 8-byte Folded Reload
; MIPS32-NEXT:    sdc1 $f0, 0($sp) # 8-byte Folded Spill
; MIPS32-NEXT:    andi $1, $1, 1
; MIPS32-NEXT:    sdc1 $f0, 24($sp) # 8-byte Folded Spill
; MIPS32-NEXT:    bnez $1, $BB0_19
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  # %bb.17: # %b.PHI.2
; MIPS32-NEXT:    j $BB0_18
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  $BB0_18: # %b.PHI.2.end
; MIPS32-NEXT:    ldc1 $f0, 0($sp) # 8-byte Folded Reload
; MIPS32-NEXT:    lw $1, 68($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    sdc1 $f0, 0($1)
; MIPS32-NEXT:    addiu $sp, $sp, 72
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  $BB0_19: # %b.PHI.3
; MIPS32-NEXT:    lw $1, 68($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    lw $2, 48($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    lw $3, 52($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    ldc1 $f0, 24($sp) # 8-byte Folded Reload
; MIPS32-NEXT:    mov.d $f4, $f0
; MIPS32-NEXT:    andi $3, $3, 1
; MIPS32-NEXT:    movn.d $f4, $f0, $3
; MIPS32-NEXT:    andi $2, $2, 1
; MIPS32-NEXT:    mov.d $f2, $f0
; MIPS32-NEXT:    movn.d $f2, $f4, $2
; MIPS32-NEXT:    sdc1 $f2, 0($1)
; MIPS32-NEXT:    sdc1 $f0, 0($1)
; MIPS32-NEXT:    addiu $sp, $sp, 72
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
entry:
  br i1 %cnd0, label %pre.PHI.2, label %pre.PHI.1

pre.PHI.1:
  br i1 %cnd1, label %b.PHI.1.1, label %pre.PHI.1.0

pre.PHI.1.0:
  br i1 %cnd2, label %b.PHI.1.2, label %b.PHI.1.0

b.PHI.1.0:
  %phi1.0 = load i64, ptr %a
  br label %b.PHI.1

b.PHI.1.1:
  %phi1.1 = load i64, ptr %b
  br label %b.PHI.1

b.PHI.1.2:
  %phi1.2 = load i64, ptr %c
  br label %b.PHI.1

b.PHI.1:
  %phi1 = phi i64 [ %phi1.0, %b.PHI.1.0 ], [ %phi1.1, %b.PHI.1.1 ], [ %phi1.2, %b.PHI.1.2 ]
  br i1 %cnd2, label %b.PHI.1.end, label %b.PHI.3

b.PHI.1.end:
  store i64 %phi1, ptr %result
  ret void

pre.PHI.2:
  br i1 %cnd0, label %b.PHI.2.0, label %b.PHI.2.1

b.PHI.2.0:
  %phi2.0 = load i64, ptr %a
  br label %b.PHI.2

b.PHI.2.1:
  %phi2.1 = load i64, ptr %b
  br label %b.PHI.2

b.PHI.2:
  %phi2 = phi i64 [ %phi2.0, %b.PHI.2.0 ], [ %phi2.1, %b.PHI.2.1 ]
   br i1 %cnd1, label %b.PHI.3, label %b.PHI.2.end

b.PHI.2.end:
  store i64 %phi2, ptr %result
  ret void

b.PHI.3:
  %phi3 = phi i64 [ %phi2, %b.PHI.2], [ %phi1, %b.PHI.1 ]
  %phi4 = phi i64 [ %phi2, %b.PHI.2], [ %phi1, %b.PHI.1 ]
  %sel_1.2 = select i1 %cnd2, i64 %phi3, i64 %phi4
  %sel_3_1.2 = select i1 %cnd1, i64 %sel_1.2, i64 %phi3
  store i64 %sel_3_1.2, ptr %result
  store i64 %phi3, ptr %result
  ret void

}

define void @long_chain_i64_in_gpr(i1 %cnd0, i1 %cnd1, i1 %cnd2, ptr %a, ptr %b, ptr %c, ptr %result) {
; MIPS32-LABEL: long_chain_i64_in_gpr:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    addiu $sp, $sp, -80
; MIPS32-NEXT:    .cfi_def_cfa_offset 80
; MIPS32-NEXT:    sw $4, 48($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    sw $5, 52($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    sw $6, 56($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    sw $7, 60($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    addiu $1, $sp, 96
; MIPS32-NEXT:    lw $1, 0($1)
; MIPS32-NEXT:    sw $1, 64($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    addiu $1, $sp, 100
; MIPS32-NEXT:    lw $1, 0($1)
; MIPS32-NEXT:    sw $1, 68($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    addiu $1, $sp, 104
; MIPS32-NEXT:    lw $1, 0($1)
; MIPS32-NEXT:    sw $1, 72($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    ori $1, $zero, 0
; MIPS32-NEXT:    sw $1, 76($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    andi $1, $4, 1
; MIPS32-NEXT:    bnez $1, $BB1_12
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  # %bb.1: # %entry
; MIPS32-NEXT:    j $BB1_2
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  $BB1_2: # %pre.PHI.1
; MIPS32-NEXT:    lw $1, 52($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    andi $1, $1, 1
; MIPS32-NEXT:    bnez $1, $BB1_7
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  # %bb.3: # %pre.PHI.1
; MIPS32-NEXT:    j $BB1_4
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  $BB1_4: # %pre.PHI.1.0
; MIPS32-NEXT:    lw $1, 56($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    andi $1, $1, 1
; MIPS32-NEXT:    bnez $1, $BB1_8
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  # %bb.5: # %pre.PHI.1.0
; MIPS32-NEXT:    j $BB1_6
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  $BB1_6: # %b.PHI.1.0
; MIPS32-NEXT:    lw $1, 60($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    lw $2, 0($1)
; MIPS32-NEXT:    lw $1, 4($1)
; MIPS32-NEXT:    sw $2, 40($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    sw $1, 44($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    j $BB1_9
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  $BB1_7: # %b.PHI.1.1
; MIPS32-NEXT:    lw $1, 64($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    lw $2, 0($1)
; MIPS32-NEXT:    lw $1, 4($1)
; MIPS32-NEXT:    sw $2, 40($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    sw $1, 44($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    j $BB1_9
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  $BB1_8: # %b.PHI.1.2
; MIPS32-NEXT:    lw $1, 68($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    lw $2, 0($1)
; MIPS32-NEXT:    lw $1, 4($1)
; MIPS32-NEXT:    sw $2, 40($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    sw $1, 44($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    j $BB1_9
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  $BB1_9: # %b.PHI.1
; MIPS32-NEXT:    lw $2, 76($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    lw $1, 56($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    lw $4, 40($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    lw $3, 44($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    sw $3, 16($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    sw $4, 20($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    andi $1, $1, 1
; MIPS32-NEXT:    sw $4, 24($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    sw $3, 28($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    move $3, $2
; MIPS32-NEXT:    sw $3, 32($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    sw $2, 36($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    bnez $1, $BB1_11
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  # %bb.10: # %b.PHI.1
; MIPS32-NEXT:    j $BB1_19
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  $BB1_11: # %b.PHI.1.end
; MIPS32-NEXT:    lw $1, 16($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    lw $2, 72($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    lw $3, 20($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    sw $3, 0($2)
; MIPS32-NEXT:    sw $1, 4($2)
; MIPS32-NEXT:    addiu $sp, $sp, 80
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  $BB1_12: # %pre.PHI.2
; MIPS32-NEXT:    lw $1, 48($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    andi $1, $1, 1
; MIPS32-NEXT:    bnez $1, $BB1_14
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  # %bb.13: # %pre.PHI.2
; MIPS32-NEXT:    j $BB1_15
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  $BB1_14: # %b.PHI.2.0
; MIPS32-NEXT:    lw $1, 60($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    lw $2, 0($1)
; MIPS32-NEXT:    lw $1, 4($1)
; MIPS32-NEXT:    sw $2, 8($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    sw $1, 12($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    j $BB1_16
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  $BB1_15: # %b.PHI.2.1
; MIPS32-NEXT:    lw $1, 64($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    lw $2, 0($1)
; MIPS32-NEXT:    lw $1, 4($1)
; MIPS32-NEXT:    sw $2, 8($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    sw $1, 12($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    j $BB1_16
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  $BB1_16: # %b.PHI.2
; MIPS32-NEXT:    lw $1, 52($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    lw $3, 8($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    lw $2, 12($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    sw $2, 0($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    sw $3, 4($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    andi $1, $1, 1
; MIPS32-NEXT:    move $4, $3
; MIPS32-NEXT:    sw $4, 24($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    move $4, $2
; MIPS32-NEXT:    sw $4, 28($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    sw $3, 32($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    sw $2, 36($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    bnez $1, $BB1_19
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  # %bb.17: # %b.PHI.2
; MIPS32-NEXT:    j $BB1_18
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  $BB1_18: # %b.PHI.2.end
; MIPS32-NEXT:    lw $1, 0($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    lw $2, 72($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    lw $3, 4($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    sw $3, 0($2)
; MIPS32-NEXT:    sw $1, 4($2)
; MIPS32-NEXT:    addiu $sp, $sp, 80
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  $BB1_19: # %b.PHI.3
; MIPS32-NEXT:    lw $2, 72($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    lw $5, 52($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    lw $7, 56($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    lw $3, 24($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    lw $1, 28($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    lw $4, 32($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    lw $6, 36($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    andi $7, $7, 1
; MIPS32-NEXT:    movn $4, $3, $7
; MIPS32-NEXT:    movn $6, $1, $7
; MIPS32-NEXT:    andi $7, $5, 1
; MIPS32-NEXT:    move $5, $3
; MIPS32-NEXT:    movn $5, $4, $7
; MIPS32-NEXT:    move $4, $1
; MIPS32-NEXT:    movn $4, $6, $7
; MIPS32-NEXT:    sw $5, 0($2)
; MIPS32-NEXT:    sw $4, 4($2)
; MIPS32-NEXT:    sw $3, 0($2)
; MIPS32-NEXT:    sw $1, 4($2)
; MIPS32-NEXT:    addiu $sp, $sp, 80
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
entry:
  br i1 %cnd0, label %pre.PHI.2, label %pre.PHI.1

pre.PHI.1:
  br i1 %cnd1, label %b.PHI.1.1, label %pre.PHI.1.0

pre.PHI.1.0:
  br i1 %cnd2, label %b.PHI.1.2, label %b.PHI.1.0

b.PHI.1.0:
  %phi1.0 = load i64, ptr %a
  br label %b.PHI.1

b.PHI.1.1:
  %phi1.1 = load i64, ptr %b
  br label %b.PHI.1

b.PHI.1.2:
  %phi1.2 = load i64, ptr %c
  br label %b.PHI.1

b.PHI.1:
  %phi1 = phi i64 [ %phi1.0, %b.PHI.1.0 ], [ %phi1.1, %b.PHI.1.1 ], [ %phi1.2, %b.PHI.1.2 ]
  br i1 %cnd2, label %b.PHI.1.end, label %b.PHI.3

b.PHI.1.end:
  store i64 %phi1, ptr %result
  ret void

pre.PHI.2:
  br i1 %cnd0, label %b.PHI.2.0, label %b.PHI.2.1

b.PHI.2.0:
  %phi2.0 = load i64, ptr %a
  br label %b.PHI.2

b.PHI.2.1:
  %phi2.1 = load i64, ptr %b
  br label %b.PHI.2

b.PHI.2:
  %phi2 = phi i64 [ %phi2.0, %b.PHI.2.0 ], [ %phi2.1, %b.PHI.2.1 ]
   br i1 %cnd1, label %b.PHI.3, label %b.PHI.2.end

b.PHI.2.end:
  store i64 %phi2, ptr %result
  ret void

b.PHI.3:
  %phi3 = phi i64 [ %phi2, %b.PHI.2], [ %phi1, %b.PHI.1 ]
  %phi4 = phi i64 [ %phi2, %b.PHI.2], [ 0, %b.PHI.1 ]
  %sel_1.2 = select i1 %cnd2, i64 %phi3, i64 %phi4
  %sel_3_1.2 = select i1 %cnd1, i64 %sel_1.2, i64 %phi3
  store i64 %sel_3_1.2, ptr %result
  store i64 %phi3, ptr %result
  ret void
}

define void @long_chain_ambiguous_double_in_fpr(i1 %cnd0, i1 %cnd1, i1 %cnd2, ptr %a, ptr %b, ptr %c, ptr %result) {
; MIPS32-LABEL: long_chain_ambiguous_double_in_fpr:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    addiu $sp, $sp, -72
; MIPS32-NEXT:    .cfi_def_cfa_offset 72
; MIPS32-NEXT:    sw $4, 44($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    sw $5, 48($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    sw $6, 52($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    sw $7, 56($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    addiu $1, $sp, 88
; MIPS32-NEXT:    lw $1, 0($1)
; MIPS32-NEXT:    sw $1, 60($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    addiu $1, $sp, 92
; MIPS32-NEXT:    lw $1, 0($1)
; MIPS32-NEXT:    sw $1, 64($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    addiu $1, $sp, 96
; MIPS32-NEXT:    lw $1, 0($1)
; MIPS32-NEXT:    sw $1, 68($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    andi $1, $4, 1
; MIPS32-NEXT:    bnez $1, $BB2_12
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  # %bb.1: # %entry
; MIPS32-NEXT:    j $BB2_2
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  $BB2_2: # %pre.PHI.1
; MIPS32-NEXT:    lw $1, 48($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    andi $1, $1, 1
; MIPS32-NEXT:    bnez $1, $BB2_7
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  # %bb.3: # %pre.PHI.1
; MIPS32-NEXT:    j $BB2_4
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  $BB2_4: # %pre.PHI.1.0
; MIPS32-NEXT:    lw $1, 52($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    andi $1, $1, 1
; MIPS32-NEXT:    bnez $1, $BB2_8
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  # %bb.5: # %pre.PHI.1.0
; MIPS32-NEXT:    j $BB2_6
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  $BB2_6: # %b.PHI.1.0
; MIPS32-NEXT:    lw $1, 56($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    ldc1 $f0, 0($1)
; MIPS32-NEXT:    sdc1 $f0, 32($sp) # 8-byte Folded Spill
; MIPS32-NEXT:    j $BB2_9
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  $BB2_7: # %b.PHI.1.1
; MIPS32-NEXT:    lw $1, 60($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    ldc1 $f0, 0($1)
; MIPS32-NEXT:    sdc1 $f0, 32($sp) # 8-byte Folded Spill
; MIPS32-NEXT:    j $BB2_9
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  $BB2_8: # %b.PHI.1.2
; MIPS32-NEXT:    lw $1, 64($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    ldc1 $f0, 0($1)
; MIPS32-NEXT:    sdc1 $f0, 32($sp) # 8-byte Folded Spill
; MIPS32-NEXT:    j $BB2_9
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  $BB2_9: # %b.PHI.1
; MIPS32-NEXT:    lw $1, 52($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    ldc1 $f0, 32($sp) # 8-byte Folded Reload
; MIPS32-NEXT:    sdc1 $f0, 16($sp) # 8-byte Folded Spill
; MIPS32-NEXT:    andi $1, $1, 1
; MIPS32-NEXT:    sdc1 $f0, 24($sp) # 8-byte Folded Spill
; MIPS32-NEXT:    bnez $1, $BB2_11
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  # %bb.10: # %b.PHI.1
; MIPS32-NEXT:    j $BB2_19
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  $BB2_11: # %b.PHI.1.end
; MIPS32-NEXT:    ldc1 $f0, 16($sp) # 8-byte Folded Reload
; MIPS32-NEXT:    lw $1, 68($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    sdc1 $f0, 0($1)
; MIPS32-NEXT:    addiu $sp, $sp, 72
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  $BB2_12: # %pre.PHI.2
; MIPS32-NEXT:    lw $1, 44($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    andi $1, $1, 1
; MIPS32-NEXT:    bnez $1, $BB2_14
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  # %bb.13: # %pre.PHI.2
; MIPS32-NEXT:    j $BB2_15
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  $BB2_14: # %b.PHI.2.0
; MIPS32-NEXT:    lw $1, 56($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    ldc1 $f0, 0($1)
; MIPS32-NEXT:    sdc1 $f0, 8($sp) # 8-byte Folded Spill
; MIPS32-NEXT:    j $BB2_16
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  $BB2_15: # %b.PHI.2.1
; MIPS32-NEXT:    lw $1, 60($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    ldc1 $f0, 0($1)
; MIPS32-NEXT:    sdc1 $f0, 8($sp) # 8-byte Folded Spill
; MIPS32-NEXT:    j $BB2_16
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  $BB2_16: # %b.PHI.2
; MIPS32-NEXT:    lw $1, 48($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    ldc1 $f0, 8($sp) # 8-byte Folded Reload
; MIPS32-NEXT:    sdc1 $f0, 0($sp) # 8-byte Folded Spill
; MIPS32-NEXT:    andi $1, $1, 1
; MIPS32-NEXT:    sdc1 $f0, 24($sp) # 8-byte Folded Spill
; MIPS32-NEXT:    bnez $1, $BB2_19
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  # %bb.17: # %b.PHI.2
; MIPS32-NEXT:    j $BB2_18
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  $BB2_18: # %b.PHI.2.end
; MIPS32-NEXT:    ldc1 $f0, 0($sp) # 8-byte Folded Reload
; MIPS32-NEXT:    lw $1, 68($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    sdc1 $f0, 0($1)
; MIPS32-NEXT:    addiu $sp, $sp, 72
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  $BB2_19: # %b.PHI.3
; MIPS32-NEXT:    lw $1, 68($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    lw $2, 48($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    lw $3, 52($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    ldc1 $f0, 24($sp) # 8-byte Folded Reload
; MIPS32-NEXT:    mov.d $f4, $f0
; MIPS32-NEXT:    andi $3, $3, 1
; MIPS32-NEXT:    movn.d $f4, $f0, $3
; MIPS32-NEXT:    andi $2, $2, 1
; MIPS32-NEXT:    mov.d $f2, $f0
; MIPS32-NEXT:    movn.d $f2, $f4, $2
; MIPS32-NEXT:    sdc1 $f2, 0($1)
; MIPS32-NEXT:    sdc1 $f0, 0($1)
; MIPS32-NEXT:    addiu $sp, $sp, 72
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
entry:
  br i1 %cnd0, label %pre.PHI.2, label %pre.PHI.1

pre.PHI.1:
  br i1 %cnd1, label %b.PHI.1.1, label %pre.PHI.1.0

pre.PHI.1.0:
  br i1 %cnd2, label %b.PHI.1.2, label %b.PHI.1.0

b.PHI.1.0:
  %phi1.0 = load double, ptr %a
  br label %b.PHI.1

b.PHI.1.1:
  %phi1.1 = load double, ptr %b
  br label %b.PHI.1

b.PHI.1.2:
  %phi1.2 = load double, ptr %c
  br label %b.PHI.1

b.PHI.1:
  %phi1 = phi double [ %phi1.0, %b.PHI.1.0 ], [ %phi1.1, %b.PHI.1.1 ], [ %phi1.2, %b.PHI.1.2 ]
  br i1 %cnd2, label %b.PHI.1.end, label %b.PHI.3

b.PHI.1.end:
  store double %phi1, ptr %result
  ret void

pre.PHI.2:
  br i1 %cnd0, label %b.PHI.2.0, label %b.PHI.2.1

b.PHI.2.0:
  %phi2.0 = load double, ptr %a
  br label %b.PHI.2

b.PHI.2.1:
  %phi2.1 = load double, ptr %b
  br label %b.PHI.2

b.PHI.2:
  %phi2 = phi double [ %phi2.0, %b.PHI.2.0 ], [ %phi2.1, %b.PHI.2.1 ]
   br i1 %cnd1, label %b.PHI.3, label %b.PHI.2.end

b.PHI.2.end:
  store double %phi2, ptr %result
  ret void

b.PHI.3:
  %phi3 = phi double [ %phi2, %b.PHI.2], [ %phi1, %b.PHI.1 ]
  %phi4 = phi double [ %phi2, %b.PHI.2], [ %phi1, %b.PHI.1 ]
  %sel_1.2 = select i1 %cnd2, double %phi3, double %phi4
  %sel_3_1.2 = select i1 %cnd1, double %sel_1.2, double %phi3
  store double %sel_3_1.2, ptr %result
  store double %phi3, ptr %result
  ret void
}


define void @long_chain_double_in_fpr(i1 %cnd0, i1 %cnd1, i1 %cnd2, ptr %a, ptr %b, ptr %c, ptr %result) {
; MIPS32-LABEL: long_chain_double_in_fpr:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    addiu $sp, $sp, -88
; MIPS32-NEXT:    .cfi_def_cfa_offset 88
; MIPS32-NEXT:    sw $4, 52($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    sw $5, 56($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    sw $6, 60($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    sw $7, 64($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    addiu $1, $sp, 104
; MIPS32-NEXT:    lw $1, 0($1)
; MIPS32-NEXT:    sw $1, 68($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    addiu $1, $sp, 108
; MIPS32-NEXT:    lw $1, 0($1)
; MIPS32-NEXT:    sw $1, 72($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    addiu $1, $sp, 112
; MIPS32-NEXT:    lw $1, 0($1)
; MIPS32-NEXT:    sw $1, 76($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    ori $2, $zero, 0
; MIPS32-NEXT:    ori $1, $zero, 0
; MIPS32-NEXT:    mtc1 $1, $f0
; MIPS32-NEXT:    mtc1 $2, $f1
; MIPS32-NEXT:    sdc1 $f0, 80($sp) # 8-byte Folded Spill
; MIPS32-NEXT:    andi $1, $4, 1
; MIPS32-NEXT:    bnez $1, $BB3_12
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  # %bb.1: # %entry
; MIPS32-NEXT:    j $BB3_2
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  $BB3_2: # %pre.PHI.1
; MIPS32-NEXT:    lw $1, 56($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    andi $1, $1, 1
; MIPS32-NEXT:    bnez $1, $BB3_7
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  # %bb.3: # %pre.PHI.1
; MIPS32-NEXT:    j $BB3_4
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  $BB3_4: # %pre.PHI.1.0
; MIPS32-NEXT:    lw $1, 60($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    andi $1, $1, 1
; MIPS32-NEXT:    bnez $1, $BB3_8
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  # %bb.5: # %pre.PHI.1.0
; MIPS32-NEXT:    j $BB3_6
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  $BB3_6: # %b.PHI.1.0
; MIPS32-NEXT:    lw $1, 64($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    ldc1 $f0, 0($1)
; MIPS32-NEXT:    sdc1 $f0, 40($sp) # 8-byte Folded Spill
; MIPS32-NEXT:    j $BB3_9
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  $BB3_7: # %b.PHI.1.1
; MIPS32-NEXT:    lw $1, 68($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    ldc1 $f0, 0($1)
; MIPS32-NEXT:    sdc1 $f0, 40($sp) # 8-byte Folded Spill
; MIPS32-NEXT:    j $BB3_9
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  $BB3_8: # %b.PHI.1.2
; MIPS32-NEXT:    lw $1, 72($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    ldc1 $f0, 0($1)
; MIPS32-NEXT:    sdc1 $f0, 40($sp) # 8-byte Folded Spill
; MIPS32-NEXT:    j $BB3_9
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  $BB3_9: # %b.PHI.1
; MIPS32-NEXT:    ldc1 $f0, 80($sp) # 8-byte Folded Reload
; MIPS32-NEXT:    lw $1, 60($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    ldc1 $f2, 40($sp) # 8-byte Folded Reload
; MIPS32-NEXT:    sdc1 $f2, 16($sp) # 8-byte Folded Spill
; MIPS32-NEXT:    andi $1, $1, 1
; MIPS32-NEXT:    sdc1 $f2, 24($sp) # 8-byte Folded Spill
; MIPS32-NEXT:    sdc1 $f0, 32($sp) # 8-byte Folded Spill
; MIPS32-NEXT:    bnez $1, $BB3_11
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  # %bb.10: # %b.PHI.1
; MIPS32-NEXT:    j $BB3_19
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  $BB3_11: # %b.PHI.1.end
; MIPS32-NEXT:    ldc1 $f0, 16($sp) # 8-byte Folded Reload
; MIPS32-NEXT:    lw $1, 76($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    sdc1 $f0, 0($1)
; MIPS32-NEXT:    addiu $sp, $sp, 88
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  $BB3_12: # %pre.PHI.2
; MIPS32-NEXT:    lw $1, 52($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    andi $1, $1, 1
; MIPS32-NEXT:    bnez $1, $BB3_14
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  # %bb.13: # %pre.PHI.2
; MIPS32-NEXT:    j $BB3_15
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  $BB3_14: # %b.PHI.2.0
; MIPS32-NEXT:    lw $1, 64($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    ldc1 $f0, 0($1)
; MIPS32-NEXT:    sdc1 $f0, 8($sp) # 8-byte Folded Spill
; MIPS32-NEXT:    j $BB3_16
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  $BB3_15: # %b.PHI.2.1
; MIPS32-NEXT:    lw $1, 68($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    ldc1 $f0, 0($1)
; MIPS32-NEXT:    sdc1 $f0, 8($sp) # 8-byte Folded Spill
; MIPS32-NEXT:    j $BB3_16
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  $BB3_16: # %b.PHI.2
; MIPS32-NEXT:    lw $1, 56($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    ldc1 $f0, 8($sp) # 8-byte Folded Reload
; MIPS32-NEXT:    sdc1 $f0, 0($sp) # 8-byte Folded Spill
; MIPS32-NEXT:    andi $1, $1, 1
; MIPS32-NEXT:    mov.d $f2, $f0
; MIPS32-NEXT:    sdc1 $f2, 24($sp) # 8-byte Folded Spill
; MIPS32-NEXT:    sdc1 $f0, 32($sp) # 8-byte Folded Spill
; MIPS32-NEXT:    bnez $1, $BB3_19
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  # %bb.17: # %b.PHI.2
; MIPS32-NEXT:    j $BB3_18
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  $BB3_18: # %b.PHI.2.end
; MIPS32-NEXT:    ldc1 $f0, 0($sp) # 8-byte Folded Reload
; MIPS32-NEXT:    lw $1, 76($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    sdc1 $f0, 0($1)
; MIPS32-NEXT:    addiu $sp, $sp, 88
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  $BB3_19: # %b.PHI.3
; MIPS32-NEXT:    lw $1, 76($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    lw $2, 56($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    lw $3, 60($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    ldc1 $f0, 24($sp) # 8-byte Folded Reload
; MIPS32-NEXT:    ldc1 $f4, 32($sp) # 8-byte Folded Reload
; MIPS32-NEXT:    andi $3, $3, 1
; MIPS32-NEXT:    movn.d $f4, $f0, $3
; MIPS32-NEXT:    andi $2, $2, 1
; MIPS32-NEXT:    mov.d $f2, $f0
; MIPS32-NEXT:    movn.d $f2, $f4, $2
; MIPS32-NEXT:    sdc1 $f2, 0($1)
; MIPS32-NEXT:    sdc1 $f0, 0($1)
; MIPS32-NEXT:    addiu $sp, $sp, 88
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
entry:
  br i1 %cnd0, label %pre.PHI.2, label %pre.PHI.1

pre.PHI.1:
  br i1 %cnd1, label %b.PHI.1.1, label %pre.PHI.1.0

pre.PHI.1.0:
  br i1 %cnd2, label %b.PHI.1.2, label %b.PHI.1.0

b.PHI.1.0:
  %phi1.0 = load double, ptr %a
  br label %b.PHI.1

b.PHI.1.1:
  %phi1.1 = load double, ptr %b
  br label %b.PHI.1

b.PHI.1.2:
  %phi1.2 = load double, ptr %c
  br label %b.PHI.1

b.PHI.1:
  %phi1 = phi double [ %phi1.0, %b.PHI.1.0 ], [ %phi1.1, %b.PHI.1.1 ], [ %phi1.2, %b.PHI.1.2 ]
  br i1 %cnd2, label %b.PHI.1.end, label %b.PHI.3

b.PHI.1.end:
  store double %phi1, ptr %result
  ret void

pre.PHI.2:
  br i1 %cnd0, label %b.PHI.2.0, label %b.PHI.2.1

b.PHI.2.0:
  %phi2.0 = load double, ptr %a
  br label %b.PHI.2

b.PHI.2.1:
  %phi2.1 = load double, ptr %b
  br label %b.PHI.2

b.PHI.2:
  %phi2 = phi double [ %phi2.0, %b.PHI.2.0 ], [ %phi2.1, %b.PHI.2.1 ]
   br i1 %cnd1, label %b.PHI.3, label %b.PHI.2.end

b.PHI.2.end:
  store double %phi2, ptr %result
  ret void

b.PHI.3:
  %phi3 = phi double [ %phi2, %b.PHI.2], [ %phi1, %b.PHI.1 ]
  %phi4 = phi double [ %phi2, %b.PHI.2], [ 0.0, %b.PHI.1 ]
  %sel_1.2 = select i1 %cnd2, double %phi3, double %phi4
  %sel_3_1.2 = select i1 %cnd1, double %sel_1.2, double %phi3
  store double %sel_3_1.2, ptr %result
  store double %phi3, ptr %result
  ret void
}

