/*
 * Decompiled with CFR 0.152.
 */
package bdvm.vm;

import bdvm.vm.common;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;

public class slots {
    private byte[][] slot_memory = new byte[500][256];
    private int attachedSlotID = 0;
    private byte[] attachStatus = new byte[]{0, 7};
    private int freeSlotPointer = 499;

    public slots() {
        this.clear();
    }

    public boolean Authenticate(int slot, byte[] hash) {
        byte[] AttachAuthenticationHash = new byte[20];
        System.arraycopy(this.slot_memory[slot], 48, AttachAuthenticationHash, 0, 20);
        if (AttachAuthenticationHash.equals(hash)) {
            this.attachedSlotID = slot;
            return true;
        }
        this.attachedSlotID = 0;
        return false;
    }

    public void AllocateNewSlot(byte[] MediaID) {
        byte[] newContent = new byte[256];
        System.arraycopy(MediaID, 0, newContent, 0, 16);
        System.arraycopy(MediaID, 0, newContent, 16, 16);
        this.attachedSlotID = this.freeSlotPointer--;
        if (this.attachStatus[1] > 2) {
            this.attachStatus[1] = (byte)(this.attachStatus[1] - 1);
        }
        this.attachStatus[0] = this.attachStatus[1];
        this.WriteSlot(newContent);
    }

    public void ResetAttachStatus() {
        this.attachedSlotID = 0;
        this.attachStatus[0] = 0;
    }

    public int[] GetAttachStatus() {
        int[] status = new int[]{this.attachedSlotID, this.attachStatus[0] << 24 >>> 24, this.attachStatus[1] << 24 >>> 24};
        return status;
    }

    public byte[] ReadCreatorMediaID() {
        byte[] BA_CreatorMediaID = new byte[16];
        System.arraycopy(this.slot_memory[this.attachedSlotID], 0, BA_CreatorMediaID, 0, 16);
        return BA_CreatorMediaID;
    }

    public int ReadUpdateSequenceCounter() {
        return common.byteArrayToInt(this.slot_memory[this.attachedSlotID], 72);
    }

    public byte[] ReadSlot(int slot) {
        byte[] slotContents = new byte[256];
        System.arraycopy(this.slot_memory[slot], 0, slotContents, 0, 32);
        if (slot == 0 || this.attachedSlotID == slot) {
            System.arraycopy(this.slot_memory[slot], 32, slotContents, 32, 16);
        }
        System.arraycopy(this.slot_memory[slot], 48, slotContents, 48, 208);
        return slotContents;
    }

    public void WriteSlot(byte[] newContents) {
        this.slot_memory[this.attachedSlotID] = newContents;
    }

    public void clear() {
        try {
            File f_flash = new File("flash.bin");
            FileInputStream flash_stream = new FileInputStream(f_flash);
            for (int i = 0; i < this.slot_memory.length; ++i) {
                flash_stream.read(this.slot_memory[i]);
            }
            flash_stream.close();
        }
        catch (FileNotFoundException fnf) {
            System.err.format("[W] No slot memory file found! Using empty slot memory.\n", new Object[0]);
            for (int i = 0; i < this.slot_memory.length; ++i) {
                Arrays.fill(this.slot_memory[i], (byte)0);
            }
        }
        catch (IOException ex) {
            System.err.format("[W] Error reading slot memory file! Slot memory may be initialized partially only!.\n", new Object[0]);
        }
        this.attachedSlotID = 0;
        this.attachStatus[0] = 0;
        this.attachStatus[1] = 7;
        this.freeSlotPointer = 499;
    }
}

