/*
 * Decompiled with CFR 0.152.
 */
package bdvm.vm;

import bdvm.vm.common;

public class conv_tab_segments {
    private int repair_descriptor_count = 0;
    private int activeRepairDescriptors = 0;
    private int encrypted = 0;
    private int[] repair_section_offset;
    private byte[][] repair_descriptor;
    private boolean[] descriptorActive;

    public conv_tab_segments(byte[] conversionTable, int segmentOffset) {
        int address = segmentOffset;
        this.repair_descriptor_count = common.byteArrayToInt(conversionTable, address);
        address += 4;
        this.activeRepairDescriptors = this.repair_descriptor_count;
        if (this.repair_descriptor_count > 0) {
            int i;
            this.encrypted = 1;
            this.repair_section_offset = new int[this.repair_descriptor_count];
            this.repair_descriptor = new byte[this.repair_descriptor_count][16];
            this.descriptorActive = new boolean[this.repair_descriptor_count];
            for (i = 0; i < this.repair_descriptor_count; ++i) {
                this.repair_section_offset[i] = common.byteArrayToInt(conversionTable, address);
                address += 4;
            }
            for (i = 0; i < this.repair_descriptor_count; ++i) {
                for (int j = 0; j < 16; ++j) {
                    this.repair_descriptor[i][j] = conversionTable[address];
                    ++address;
                }
            }
        }
    }

    public int length() {
        return 4 + 20 * this.activeRepairDescriptors;
    }

    public boolean needsDecryption() {
        return this.encrypted == 1 && this.repair_descriptor_count > 0;
    }

    public boolean decrypt(byte[] segmentKey) {
        if (this.encrypted != 1) {
            return false;
        }
        for (int i = 0; i < this.repair_descriptor_count; ++i) {
            for (int j = 0; j < 16; ++j) {
                byte[] byArray = this.repair_descriptor[i];
                int n = j;
                byArray[n] = (byte)(byArray[n] ^ segmentKey[j]);
            }
        }
        this.encrypted = 0;
        return true;
    }

    public void check(byte[] segmentMask) {
        int i;
        block4: for (i = 0; i < this.repair_descriptor_count; ++i) {
            byte descriptorID = this.repair_descriptor[i][0];
            switch (descriptorID >>> 6 & 3) {
                case 1: {
                    this.descriptorActive[i] = true;
                    ++this.activeRepairDescriptors;
                    continue block4;
                }
                case 2: {
                    byte byteAddress = (byte)(descriptorID >>> 3 & 7);
                    byte bitAddress = (byte)(descriptorID & 7);
                    if ((segmentMask[7 - byteAddress] & 1 << bitAddress) != 0) {
                        this.descriptorActive[i] = true;
                        ++this.activeRepairDescriptors;
                        continue block4;
                    }
                    this.descriptorActive[i] = false;
                    continue block4;
                }
                default: {
                    this.descriptorActive[i] = false;
                }
            }
        }
        this.activeRepairDescriptors = 0;
        for (i = 0; i < this.descriptorActive.length; ++i) {
            if (!this.descriptorActive[i]) continue;
            ++this.activeRepairDescriptors;
        }
    }

    public byte[] toByteArray() {
        int i;
        int writeAddress = 0;
        byte[] BA_segment = new byte[4 + 20 * this.activeRepairDescriptors];
        common.int32ToByteArray(this.activeRepairDescriptors, BA_segment, writeAddress);
        writeAddress += 4;
        for (i = 0; i < this.repair_descriptor_count; ++i) {
            if (!this.descriptorActive[i]) continue;
            common.int32ToByteArray(this.repair_section_offset[i], BA_segment, writeAddress);
            writeAddress += 4;
        }
        for (i = 0; i < this.repair_descriptor_count; ++i) {
            if (!this.descriptorActive[i]) continue;
            System.arraycopy(this.repair_descriptor[i], 0, BA_segment, writeAddress, 16);
            writeAddress += 16;
        }
        return BA_segment;
    }
}

